﻿using System;

namespace SDRSharp.Trunker
{
    public class TrunkerSettings
    {
        private String _unitrunkerPath;
        private String _logPath;
        private bool _enabled;
        private bool _loggingEnabled;
        private bool _delayRetune;
        private bool _tuneControl;
        private bool _muteEDACS;
        private bool _muteControl;
        private bool _ignoreParked;
        private int _delayRetuneMethod;
        private decimal _controlFreq;
        private decimal _delayRetuneMinimumSignal;
        private String _logStyle;
        private String _parkedString;
        private String _unknownSrcString;

        public TrunkerSettings() { }

        public TrunkerSettings(TrunkerSettings trunkerSettings)
        {
            _enabled = trunkerSettings._enabled;
            _ignoreParked = trunkerSettings._ignoreParked;
            _parkedString = trunkerSettings._parkedString;
            _unknownSrcString = trunkerSettings._unknownSrcString;
            _unitrunkerPath = trunkerSettings._unitrunkerPath;
            _logPath = trunkerSettings._logPath;
            _loggingEnabled = trunkerSettings._loggingEnabled;
            _delayRetune = trunkerSettings._delayRetune;
            _delayRetuneMethod = trunkerSettings._delayRetuneMethod;
            _delayRetuneMinimumSignal = trunkerSettings._delayRetuneMinimumSignal;
            _tuneControl = trunkerSettings._tuneControl;
            _muteEDACS = trunkerSettings._muteEDACS;
            _muteControl = trunkerSettings._muteControl;
            _controlFreq = trunkerSettings._controlFreq;
            _logStyle = trunkerSettings._logStyle;
        }

        public void settingsExist()
        {
            // this doesn't return anything
            // this exists to test for the array index in TrunkerPanel.cs
            // If the index is not defined in TrunkerPanel.cs, it will throw an exception, allowing us to create the index.

            // This is probably not the most optimal way of doing things, but it works.
        }

        public bool isEnabled
        {
            get { return _enabled; }
            set { _enabled = value; }
        }

        public bool ignoreParked
        {
            get { return _ignoreParked; }
            set { _ignoreParked = value; }
        }

        public string unitrunkerPath
        {
            get { return _unitrunkerPath; }
            set { _unitrunkerPath = value; }
        }

        public string parkedStr
        {
            get { return _parkedString; }
            set { _parkedString = value; }
        }

        public string unknownSrcStr
        {
            get { return _unknownSrcString; }
            set { _unknownSrcString = value; }
        }

        public string logStyle
        {
            get { return _logStyle; }
            set { _logStyle = value; }
        }

        public string logPath
        {
            get { return _logPath; }
            set { _logPath = value; }
        }

        public bool isLoggingEnabled
        {
            get { return _loggingEnabled; }
            set { _loggingEnabled = value; }
        }

        public bool isDelayRetuneEnabled
        {
            get { return _delayRetune; }
            set { _delayRetune = value; }
        }

        public bool isControlAutotuneEnabled
        {
            get { return _tuneControl; }
            set { _tuneControl = value; }
        }

        public bool isMuteEDACSEnabled
        {
            get { return _muteEDACS; }
            set { _muteEDACS = value; }
        }

        public bool isMuteControlEnabled
        {
            get { return _muteControl; }
            set { _muteControl = value; }
        }

        public decimal controlFreq
        {
            get { return _controlFreq; }
            set { _controlFreq = value; }
        }

        public int delayRetuneMethod
        {
            get { return _delayRetuneMethod; }
            set { _delayRetuneMethod = value; }
        }

        public decimal delayRetuneMinimumSignal
        {
            get { return _delayRetuneMinimumSignal; }
            set { _delayRetuneMinimumSignal = value; }
        }
    }
              
}
