﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data;

using SDRSharp.Common;
using SDRSharp.Radio;

namespace SDRSharp.Trunker
{
    //public unsafe class TrunkerPlugin : ISharpPlugin, IAudioProcessor
	public unsafe class TrunkerPlugin : ISharpPlugin, IRealProcessor
    {
        private const string _displayName = "Trunker";
        private ISharpControl _controlInterface;
		private TrunkerPanel _trunkerPanel;
		//private AudioProcessor _audioProcessor;

        private double _sampleRate;
		private bool _bypass = true;
		private bool _enabled = true;

		public void Initialize( ISharpControl control )
		{
			_controlInterface = control;
			//_controlInterface.RegisterStreamHook(this);
			_controlInterface.RegisterStreamHook(this, ProcessorType.DemodulatorOutput);

			_trunkerPanel = new TrunkerPanel( _controlInterface, this );
		}

		public UserControl GuiControl
		{
			get { return _trunkerPanel; }
		}

		public string DisplayName
		{
			get { return _displayName; }
		}

		public bool HasGui
		{
			get { return true; }
		}

        public bool Bypass
        {
            get { return _bypass; }
            set { _bypass = value; }
        }

		public bool Enabled
		{
			get { return _enabled; }
			set { _enabled = value; }
		}

        public double SampleRate
        {
            get { return _sampleRate; }
            set { _sampleRate = value; }
        }

        public void Process(float* audioBuffer, int length)
        {
            if( !_bypass )
            {
                _trunkerPanel.MuteBeeps(audioBuffer, length);
            }
        }

        public void Close()
        {
        }
    }
}