﻿using System.Collections.Generic;
using System.IO;
using System.Xml.Serialization;
using System.Windows.Forms;

namespace SDRSharp.Trunker
{
    public class SettingsPersisterTrunker
    {
        private const string SettingsFilename = "trunker.xml";

        private readonly string _settingsFolder;

        public SettingsPersisterTrunker()
        {
            //_settingsFolder = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData), "SDRSharp");
            _settingsFolder = Path.GetDirectoryName(Application.ExecutablePath);
        }

        public List<TrunkerSettings> readConfig()
        {
            if (File.Exists(SettingsFilename))
            {
                var result = ReadObject<List<TrunkerSettings>>(SettingsFilename);
                if (result != null)
                {
                    return result;
                }
            }
            return new List<TrunkerSettings>();
        }

        public void writeConfig(List<TrunkerSettings> config)
        {
            WriteObject(config, SettingsFilename);
        }

        private T ReadObject<T>(string fileName)
        {
            var filePath = Path.Combine(_settingsFolder, fileName);
            if (File.Exists(filePath))
            {
                using (var fileStream = new FileStream(filePath, FileMode.Open))
                {
                    var ser = new XmlSerializer(typeof(T));
                    return (T)ser.Deserialize(fileStream);
                }
            }
            return default(T);
        }

        private void WriteObject<T>(T obj, string fileName)
        {
            var filePath = Path.Combine(_settingsFolder, fileName);
            using (FileStream fileStream = new FileStream(filePath, FileMode.Create))
            {
                var ser = new XmlSerializer(obj.GetType());
                ser.Serialize(fileStream, obj);
            }
        }
    }
}
