﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SDRSharp.Trunker
{
    public class LogParser
    {
        public static string ParseLogStyle(TrunkerLogger _trunkLoggerData, string logStyle = null, string parkedString = null, string unkString = null, bool ignoreParked = false)
        {
            // Prepare the logger data by filtering _trunkLoggerData through PrepareLogData();
            if (logStyle == null || parkedString == null || unkString == null || ignoreParked == false)
            {
                string[] settings = getSettings();
                if (logStyle == null)
                    logStyle = settings[0];
                if (parkedString == null)
                    parkedString = settings[1];
                if (unkString == null)
                    unkString = settings[2];
                // ignoreParked may legitimatly be false, but we can't assign null.. so we have to check now.
                if (ignoreParked == false)
                    ignoreParked = Convert.ToBoolean(settings[3]);

            }
            _trunkLoggerData = PrepareLogData(_trunkLoggerData, parkedString, unkString);

            // If we are parked, and ignoring parked, just stop processing right now
            if (_trunkLoggerData.currentAction == "Park" && ignoreParked)
            {
                return null;
            }

            // Filter the data using the specified log style

            // Most data should always be populated, however the following may be null depending on the situatation
            // %sid will be null if no source is provided by Unitrunker and %a = Listen (%s will be set to "Unknown")
            // %tid, %s, and %sid will be null if %a = Park (%t will be set to "Parked")

            string outstring = logStyle;
            int loc = -1;            
            int lastloc = loc;

            // This is a hot mess...
            // Basically we take anything in [] and apply it conditionally
            // Example: Say you set the logStyle to "[%s to ]%t", and %s is null, we should only return "%t".
            // However if %s is defined, we should return "%s to %t"
            parserSearch:
            if ((loc+1) <= outstring.Length) {
                loc = outstring.IndexOf('[',(loc+1));
                if (loc >= 0)
                {
                    int endloc = outstring.IndexOf(']', loc);
                    if (endloc >= 0)
                    {
                        // capture the section of the string in this set of brackets, and copy it
                        // so we still have the original and we know what to replace
                        string preprocessed = outstring.Substring(loc, ((endloc - loc)+1));
                        string processed = preprocessed;

                        int varStart = preprocessed.IndexOf('%');
                        if (varStart > 0)
                        {
                            string theVar;
                            if (processed.Length >= (varStart + 4))
                            {
                                // The string seems long enough to contain a 3 letter code, so we'll assume it does for now
                                theVar = preprocessed.Substring(varStart, 4);
                            }
                            else
                            {
                                // The string is not long enough for a 3 letter code, assume 1 letter code
                                theVar = preprocessed.Substring(varStart, 2);
                            }
                            switch (theVar)
                            {
                                case "%tid":
                                    processed = filterData(preprocessed, theVar, _trunkLoggerData.currentTrunkgroup);
                                    break;
                                case "%sid":
                                    processed = filterData(preprocessed, theVar, _trunkLoggerData.currentSourcegroup);
                                    break;

                                default:
                                    // We tried processing it at as 3 letter code but did not succeed, so lets chop it down to a single letter code
                                    // This is a completely horrible way of doing this (hell this entire class probably is), but whatever.
                                    // Feel free to make it better ;)

                                    theVar = theVar.Substring(0, 2); // % + 1 char

                                    // Yay, nested switch. How horrible can I make this code?????
                                    switch (theVar)
                                    {
                                        case "%s":
                                            processed = filterData(preprocessed, theVar, _trunkLoggerData.currentSourcelabel);
                                            break;
                                    }
                                    break;
                            }
                            if (preprocessed != processed)
                                outstring = outstring.Replace(preprocessed, processed);
                        }
                        lastloc = endloc;
                    }
                    if (lastloc > loc)
                    {
                        loc = lastloc;
                        goto parserSearch;
                    }
                }
            }



            outstring = outstring.Replace("%fk", (_trunkLoggerData.currentFrequency / 1000).ToString());
            outstring = outstring.Replace("%fm", (_trunkLoggerData.currentFrequency / 1000000).ToString());
            outstring = outstring.Replace("%f", _trunkLoggerData.currentFrequency.ToString());
            outstring = outstring.Replace("%tid", _trunkLoggerData.currentTrunkgroup);
            outstring = outstring.Replace("%t", _trunkLoggerData.currentTrunklabel);
            outstring = outstring.Replace("%sid", _trunkLoggerData.currentSourcegroup);
            outstring = outstring.Replace("%s", _trunkLoggerData.currentSourcelabel);
            outstring = outstring.Replace("%r", _trunkLoggerData.currentReceiver);
            outstring = outstring.Replace("%a", _trunkLoggerData.currentAction);
            return outstring;
        }

        private static string filterData(string source, string var, object loggerData) {
            if (loggerData != null)
            {
                // Allow it through, replacing the var and removing []
                source = source.Replace(var, loggerData.ToString());
                source = source.Remove(source.IndexOf('[', 0), 1);
                source = source.Remove(source.IndexOf(']', 0), 1);
            }
            else
            {
                // The var is null, so return nothing;
                source = null;
            }
            return source;
        }

        private static TrunkerLogger PrepareLogData(TrunkerLogger _trunkLoggerData, string parkedStr, string unkString)
        {
            // Set parking target to "Parked"
            if (_trunkLoggerData.currentAction == "Park")
            {
                _trunkLoggerData.currentTrunklabel = parkedStr;
            }

            if (_trunkLoggerData.currentAction == "Listen")
            {
                // Assign label the ID number if the label is blank
                if (_trunkLoggerData.currentTrunklabel == null || _trunkLoggerData.currentTrunklabel.Length == 0)
                    _trunkLoggerData.currentTrunklabel = _trunkLoggerData.currentTrunkgroup;

                // Source is a bit trickier since both can be blank. First we try assigning the ID if label is blank
                if (_trunkLoggerData.currentSourcelabel == null || _trunkLoggerData.currentSourcelabel.Length == 0)
                    _trunkLoggerData.currentSourcelabel = _trunkLoggerData.currentSourcegroup;

                // If this part runs, both Source ID and Label are blank, so we assign "Unknown":
                if (_trunkLoggerData.currentSourcelabel == null || _trunkLoggerData.currentSourcelabel.Length == 0)
                    _trunkLoggerData.currentSourcelabel = unkString;
            }
            return _trunkLoggerData;
        }

        private static string[] getSettings()
        {
            SettingsPersisterTrunker _settingsPersister;
            List<TrunkerSettings> _trunkerConfig;
            _settingsPersister = new SettingsPersisterTrunker();
            _trunkerConfig = _settingsPersister.readConfig();
            string logStyle = _trunkerConfig[0].logStyle ?? "%t %fm MHz";
            string parkedString = _trunkerConfig[0].parkedStr ?? "Parked";
            string unkString = _trunkerConfig[0].unknownSrcStr ?? "Unknown";
            bool ignoreParked = _trunkerConfig[0].ignoreParked || false;
            return new string[4] { logStyle, parkedString, unkString, ignoreParked.ToString() };
        }
    }
}
