﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SDRSharp.Trunker
{
    public partial class LogOptions : Form
    {
        private readonly SettingsPersisterTrunker _settingsPersister;
        private TrunkerLogger _trunkLoggerData;
        private List<TrunkerSettings> _trunkerConfig;


        public LogOptions()
        {
            InitializeComponent();
            _settingsPersister = new SettingsPersisterTrunker();
            _trunkerConfig = _settingsPersister.readConfig();
            _trunkLoggerData = new TrunkerLogger();
            this.guideLabel.Text = "Guide:" + Environment.NewLine + "%t = targetlabel" + Environment.NewLine + "%tid = targetid" + Environment.NewLine + "%s = sourcelabel" + Environment.NewLine + "%sid = sourceid" + Environment.NewLine + "%f = frequency (Hz)" + Environment.NewLine + "%fk  = frequency (kHz)" + Environment.NewLine + "%fm  = frequency (MHz)" + Environment.NewLine + "%a = action" + Environment.NewLine + "%r = receiver";
            this.guideLabel2.Text = "To filter strings based on variable availabity, use brackets. Please try some presets from the dropdown list above, as well as the simulator for examples on how this works."  + Environment.NewLine + "Nested filters are not currently supported." + Environment.NewLine + "Only works on %tid, %s, and %sid.";
            this.logSimulation.SelectedIndex = 0;
            this.logStyle.Text = _trunkerConfig[0].logStyle ?? "%t %fm MHz";
            this.parkedString.Text = _trunkerConfig[0].parkedStr ?? "Parked";
            this.unkString.Text = _trunkerConfig[0].unknownSrcStr ?? "Unknown";
            this.ignoreParked.Checked = _trunkerConfig[0].ignoreParked || false;
        }

        private void PrepareLog()
        {
            // Wipe the log data to prepare for new
            _trunkLoggerData = null;
            _trunkLoggerData = new TrunkerLogger();
        }

        private void PopulateFakeLog()
        {
            PrepareLog();
            _trunkLoggerData.currentFrequency = 860987725;
            _trunkLoggerData.currentReceiver = "Debug";
            _trunkLoggerData.currentTrunklabel = "Test Target";
            _trunkLoggerData.currentTrunkgroup = "1234";
            switch (logSimulation.SelectedIndex+1) {
                case 1:
                    // Parked
                    _trunkLoggerData.currentAction = "Park";
                    _trunkLoggerData.currentTrunklabel = null;
                    _trunkLoggerData.currentTrunkgroup = null;
                    break;
                case 2:
                    // Full
                    _trunkLoggerData.currentAction = "Listen";
                    _trunkLoggerData.currentSourcegroup = "420";
                    _trunkLoggerData.currentSourcelabel = "Test Source";
                    break;
            }
        }

        private void DoNothing(Exception ex)
        {
            // it is kinda pointless, and a waste of space, but it shuts up the VS Warnings for unused variables
        }

        private void logCustomizeSave_Click(object sender, EventArgs e)
        {
            try
            {
                _trunkerConfig[0].settingsExist();
            }
            catch (Exception ex)
            {
                DoNothing(ex);
                _trunkerConfig.Insert(0, new TrunkerSettings());
            }
            _trunkerConfig[0].logStyle = logStyle.Text;
            _trunkerConfig[0].parkedStr = parkedString.Text;
            _trunkerConfig[0].unknownSrcStr = unkString.Text;
            _trunkerConfig[0].ignoreParked = this.ignoreParked.Checked;
            _settingsPersister.writeConfig(_trunkerConfig);
            this.Close();
        }

        private void logStyle_TextChanged(object sender, EventArgs e)
        {
            string outstring = doLogParse();
            if (outstring != null)
                this.exampleOut.Text = outstring;

        }

        private void logStylePreset_SelectedIndexChanged(object sender, EventArgs e)
        {
            // target frequency
            // target (frequency)
            // target source
            // target source frequency
            // source to target
            // source to target (frequency)
            // source
            // target
            // frequency
            switch (logStylePreset.SelectedIndex + 1)
            {
                case 2:
                    logStyle.Text = "%t (%fm MHz)";
                    break;
                case 3:
                    logStyle.Text = "%t[ %s]";
                    break;
                case 4:
                    logStyle.Text = "%t[ %s] %fm MHz";
                    break;
                case 5:
                    logStyle.Text = "[%s to ]%t";
                    break;
                case 6:
                    logStyle.Text = "[%s to ]%t (%fm MHz)";
                    break;
                case 7:
                    logStyle.Text = "%s";
                    break;
                case 8:
                    logStyle.Text = "%t";
                    break;
                case 9:
                    logStyle.Text = "%fm MHz";
                    break;


                default:
                    // 1, or selectedIndex 0
                    logStyle.Text = "%t %fm MHz";
                    break;
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void logSimulation_SelectedIndexChanged(object sender, EventArgs e)
        {
            PopulateFakeLog();
            string outstring = doLogParse();
            if (outstring != null)
                this.exampleOut.Text = outstring;
        }

        private string doLogParse()
        {
            return LogParser.ParseLogStyle(_trunkLoggerData, this.logStyle.Text, this.parkedString.Text, this.unkString.Text, this.ignoreParked.Checked);
        }

        private void parkedString_TextChanged(object sender, EventArgs e)
        {
            string outstring = doLogParse();
            if (outstring != null)
                this.exampleOut.Text = outstring;
        }

        private void unkString_TextChanged(object sender, EventArgs e)
        {
            string outstring = doLogParse();
            if (outstring != null)
                this.exampleOut.Text = outstring;
        }

        private void ignoreParked_CheckedChanged(object sender, EventArgs e)
        {
            // Boot the user off the Parked simulation so they can set it back and see it in action
            if (this.logSimulation.SelectedIndex == 0)
            {
                this.logSimulation.SelectedIndex = 1;
            }
        }

    }
}
