﻿using System;
using SDRSharp.Radio;

namespace SDRSharp.Trunker
{
    public unsafe class Goertzel
    {
        //this entire thing written by dos_fan], i just added one variable that seemed to be apropos given my level of understanding of what is going on
        static public float GetMag(double sampleRate, int frequency, float* buffer, int length)
        {

            float q0, q1, q2;

            var k = (int)(0.5 + ((length * frequency) / sampleRate));
            var omega = (2.0 * Math.PI * k) / length;
            var coeff = (float)(2.0 * Math.Cos(omega));

            q0 = q1 = q2 = 0.0f;
            for (var i = 0; i < length; i++)
            {
                q0 = coeff * q1 - q2 + buffer[i];
                q2 = q1;
                q1 = q0;
            }

            var scale = length / 2.0f;

            var real = (float)(q1 - q2 * Math.Cos(omega)) / scale;
            var imag = (float)(q2 * Math.Sin(omega)) / scale;

            return (float)Math.Sqrt(real * real + imag * imag);
        }

    }
}