@echo off

tasklist /FI "IMAGENAME eq SDRSharp.exe" 2>NUL | find /I /N "SDRSharp.exe">NUL
if %errorlevel% equ 1 goto start

echo:
echo Close SDRSharp Before Upgrading!
echo:
goto end

:start
httpget http://sdrsharp.com/rev.aspx latestversion.txt

if not exist installedversion.txt goto install
fc /L latestversion.txt installedversion.txt > nul
if %errorlevel% equ 0 goto latest

if exist sdrsharp\plugins.xml copy sdrsharp\plugins.xml sdrsharp\plugins.xml.saved

:install
mkdir src

echo Downloading SDR# ...
httpget http://sdrsharp.com/downloads/sdr-nightly.zip src\sdr-nightly.zip

echo Downloading SDR#'s RTLSDR Plugin ...
httpget http://sdrsharp.com/downloads/sdr-nightly-rtlsdr.zip src\sdr-nightly-rtlsdr.zip

echo Downloading ADSB# ...
httpget http://sdrsharp.com/downloads/adsbsharp.zip src\adsbsharp.zip

echo Downloading RTLSDR Driver
httpget http://sdr.osmocom.org/trac/raw-attachment/wiki/rtl-sdr/RelWithDebInfo.zip src\RelWithDebInfo.zip

echo Downloading Zadig
set zadig_exe=zadig.exe
ver | findstr /l "5.1." > NUL
if %errorlevel% equ 0 set zadig_exe=zadig_xp.exe
httpget http://zadig.akeo.ie/downloads/%zadig_exe% src\%zadig_exe%

mkdir tmp

unzip -o src\sdr-nightly.zip -d sdrsharp

unzip -o src\sdr-nightly-rtlsdr.zip -d tmp
move tmp\SDRSharp.RTLSDR.dll sdrsharp
move tmp\msvcr100.dll sdrsharp
move tmp\libusb-1.0.dll sdrsharp
move tmp\libusb0.dll sdrsharp
move /Y tmp\config\SDRSharp.exe.config sdrsharp

unzip -o src\adsbsharp.zip -d sdrsharp

unzip -o src\RelWithDebInfo.zip -d tmp
move tmp\rtl-sdr-release\x32\rtlsdr.dll sdrsharp

move src\%zadig_exe% sdrsharp

rmdir src /S /Q
rmdir tmp /S /Q

if not exist "sdrsharp\plugins.xml.saved" goto next1
copy sdrsharp\plugins.xml.saved sdrsharp\plugins.xml
:next1
copy latestversion.txt installedversion.txt

echo:
echo Installed Latest Version
type installedversion.txt
echo:
goto :end

:latest
echo:
echo Latest Version Already Installed
type installedversion.txt
echo:

echo Do You Wish to Reinstall?
set /p reinstall=Overwrite Existing Installation [y/N]?: 
if /I "%reinstall%" == "y" goto install

:end
if exist latestversion.txt del latestversion.txt
pause
